unit ID2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ExtCtrls, ID3v2, BusinessSkinForm;

type
  TFormId3 = class(TForm)
    CloseButton: TButton;
    InfoBevel: TBevel;
    IconImage: TImage;
    TagExistsLabel: TLabel;
    TagExistsValue: TEdit;
    VersionLabel: TLabel;
    VersionValue: TEdit;
    SizeLabel: TLabel;
    SizeValue: TEdit;
    TitleLabel: TLabel;
    TitleEdit: TEdit;
    ArtistLabel: TLabel;
    ArtistEdit: TEdit;
    AlbumLabel: TLabel;
    AlbumEdit: TEdit;
    TrackLabel: TLabel;
    TrackEdit: TEdit;
    YearLabel: TLabel;
    YearEdit: TEdit;
    GenreLabel: TLabel;
    GenreEdit: TEdit;
    CommentLabel: TLabel;
    CommentEdit: TEdit;
    RemoveButton: TButton;
    SaveButton: TButton;
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    Edit1: TEdit;
    Button1: TButton;
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SaveButtonClick(Sender: TObject);
    procedure RemoveButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);

  private
    { Private declarations }
    FileTag: TID3v2;
    procedure ClearAll;
  public
    Procedure GetID(filename:string);
    Procedure SaveId(filename:string);
    procedure RemoveID(filename:string);
  end;

var
  FormId3: TFormId3;

implementation

uses form_mainform;

{$R *.dfm}

procedure TFormId3.ClearAll;
begin
  { Clear all captions }
  TagExistsValue.Text := '';
  VersionValue.Text := '';
  SizeValue.Text := '';
  TitleEdit.Text := '';
  ArtistEdit.Text := '';
  AlbumEdit.Text := '';
  TrackEdit.Text := '';
  YearEdit.Text := '';
  GenreEdit.Text := '';
  CommentEdit.Text := '';
end;

procedure TFormId3.CloseButtonClick(Sender: TObject);
begin
  { Exit }
  Close;
end;

procedure TFormId3.FormCreate(Sender: TObject);
begin
  { Create object and clear captions }
  FileTag := TID3v2.Create;
  ClearAll;
end;

Procedure TFormID3.GetID(filename:string);
begin
  { Clear captions }
  ClearAll;
  if FileExists(FileName) then
    { Load tag data }
    if FileTag.ReadFromFile(FileName) then
      if FileTag.Exists then
      begin
        { Fill captions }
        TagExistsValue.Text := 'Yes';
        VersionValue.Text := '2.' + IntToStr(FileTag.VersionID);
        SizeValue.Text := IntToStr(FileTag.Size) + ' bytes';
        TitleEdit.Text := FileTag.Title;
        ArtistEdit.Text := FileTag.Artist;
        AlbumEdit.Text := FileTag.Album;
        if FileTag.Track > 0 then TrackEdit.Text := IntToStr(FileTag.Track);
        YearEdit.Text := FileTag.Year;
        GenreEdit.Text := FileTag.Genre;
        CommentEdit.Text := FileTag.Comment;
        filetag.ResetData;
      end
      else
        { Tag not found }
        TagExistsValue.Text := 'No'
    else
      { Read error }
      mainform.message.MessageDlg('Can not read tag from the file: ' + FileName,mtconfirmation,[mbok],0)
  else
    { File does not exist }
      mainform.message.MessageDlg('The file does not exist: ' + FileName,mtconfirmation,[mbok],0);
end;


procedure TFormId3.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  { Free memory }
end;

procedure TFormId3.SaveID(filename:string);
var
  Value, Code: Integer;
begin
  { Prepare tag data }
  FileTag.Title := TitleEdit.Text;
  FileTag.Artist := ArtistEdit.Text;
  FileTag.Album := AlbumEdit.Text;
  Val(TrackEdit.Text, Value, Code);
  if (Code = 0) and (Value > 0) then FileTag.Track := Value
  else FileTag.Track := 0;
  FileTag.Year := YearEdit.Text;
  FileTag.Genre := GenreEdit.Text;
  FileTag.Comment := CommentEdit.Text;
  { Save tag data }
  if (not FileExists(FileName)) or
    (not FileTag.SaveToFile(FileName)) then
  mainform.message.MessageDlg('File in use! Can not save tag to the file: ' + FileName,mtconfirmation,[mbok],0);
  filetag.ResetData;
end;

procedure TFormId3.SaveButtonClick(Sender: TObject);
var
  Value, Code: Integer;
begin
  { Prepare tag data }
  FileTag.Title := TitleEdit.Text;
  FileTag.Artist := ArtistEdit.Text;
  FileTag.Album := AlbumEdit.Text;
  Val(TrackEdit.Text, Value, Code);
  if (Code = 0) and (Value > 0) then FileTag.Track := Value
  else FileTag.Track := 0;
  FileTag.Year := YearEdit.Text;
  FileTag.Genre := GenreEdit.Text;
  FileTag.Comment := CommentEdit.Text;
  { Save tag data }
  if (not FileExists(edit1.Text)) or
    (not FileTag.SaveToFile(edit1.Text)) then
  mainform.message.MessageDlg('File in use! Can not save tag to the file: ' + edit1.Text,mtconfirmation,[mbok],0);
  filetag.ResetData;
end;

procedure TFormId3.RemoveID(filename:string);
begin
  { Delete tag data }
  if (FileExists(FileName)) and
    (FileTag.RemoveFromFile(FileName)) then ClearAll
  else mainform.message.MessageDlg('Can not remove tag from the file: ' + edit1.Text,mtconfirmation,[mbok],0);
end;

procedure TFormId3.RemoveButtonClick(Sender: TObject);
begin
  { Delete tag data }
  if (FileExists(edit1.Text)) and
    (FileTag.RemoveFromFile(edit1.Text)) then ClearAll
  else mainform.message.MessageDlg('Can not remove tag from the file: ' + edit1.Text,mtconfirmation,[mbok],0);
end;

procedure TFormId3.Button1Click(Sender: TObject);
begin
  { Clear captions }
  ClearAll;
  if edit1.Text = '' then exit;
  if FileExists(edit1.Text) then
    { Load tag data }
    if FileTag.ReadFromFile(edit1.Text) then
      if FileTag.Exists then
      begin
        { Fill captions }
        TagExistsValue.Text := 'Yes';
        VersionValue.Text := '2.' + IntToStr(FileTag.VersionID);
        SizeValue.Text := IntToStr(FileTag.Size) + ' bytes';
        TitleEdit.Text := FileTag.Title;
        ArtistEdit.Text := FileTag.Artist;
        AlbumEdit.Text := FileTag.Album;
        if FileTag.Track > 0 then TrackEdit.Text := IntToStr(FileTag.Track);
        YearEdit.Text := FileTag.Year;
        GenreEdit.Text := FileTag.Genre;
        CommentEdit.Text := FileTag.Comment;
        filetag.ResetData;
      end
      else
        { Tag not found }
        TagExistsValue.Text := 'No'
    else
      { Read error }
      mainform.message.MessageDlg('Can not read tag from the file: ' + edit1.Text,mtconfirmation,[mbok],0)
  else
    { File does not exist }
    mainform.message.MessageDlg('The file does not exist: ' + edit1.Text,mtconfirmation,[mbok],0);
end;

end.
